/*
 * Decompiled with CFR 0.152.
 */
package me.jddev0.ep.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import me.jddev0.ep.api.EPAPI;
import me.jddev0.ep.block.EPBlocks;
import me.jddev0.ep.block.entity.FiltrationPlantBlockEntity;
import me.jddev0.ep.fluid.EPFluids;
import me.jddev0.ep.recipe.FiltrationPlantRecipe;
import me.jddev0.ep.recipe.OutputItemStackWithPercentages;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_8786;

public class FiltrationPlantEMIRecipe
implements EmiRecipe {
    public static final class_2960 SIMPLIFIED_TEXTURE = EPAPI.id("textures/block/filtration_plant_front.png");
    public static final EmiStack ITEM = EmiStack.of((class_1935)EPBlocks.FILTRATION_PLANT_ITEM);
    public static final EmiRecipeCategory CATEGORY = new EmiRecipeCategory(EPAPI.id("filtration_plant"), (EmiRenderable)ITEM, (EmiRenderable)new EmiTexture(SIMPLIFIED_TEXTURE, 0, 0, 16, 16, 16, 16, 16, 16));
    private final class_2960 id;
    private final List<EmiIngredient> input;
    private final List<EmiStack> output;
    private final OutputItemStackWithPercentages outputWithPercentages;
    private final OutputItemStackWithPercentages secondaryOutputWithPercentages;

    public FiltrationPlantEMIRecipe(class_8786<FiltrationPlantRecipe> recipe) {
        this.id = recipe.comp_1932();
        this.input = List.of(EmiStack.of((class_3611)EPFluids.DIRTY_WATER, (long)FiltrationPlantBlockEntity.DIRTY_WATER_CONSUMPTION_PER_RECIPE));
        this.output = Arrays.stream(((FiltrationPlantRecipe)recipe.comp_1933()).getMaxOutputCounts()).filter(itemStack -> !itemStack.method_7960()).map(EmiStack::of).toList();
        this.outputWithPercentages = ((FiltrationPlantRecipe)recipe.comp_1933()).getOutput();
        this.secondaryOutputWithPercentages = ((FiltrationPlantRecipe)recipe.comp_1933()).getSecondaryOutput();
    }

    public EmiRecipeCategory getCategory() {
        return CATEGORY;
    }

    public class_2960 getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.input;
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 112;
    }

    public int getDisplayHeight() {
        return 26;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 28, 4);
        widgets.addSlot(this.input.get(0), 0, 4);
        SlotWidget outputSlot = widgets.addSlot((EmiIngredient)this.output.get(0), 63, 4).recipeContext((EmiRecipe)this);
        outputSlot.appendTooltip((class_2561)class_2561.method_43471((String)"recipes.energizedpower.transfer.output_percentages"));
        double[] percentages = this.outputWithPercentages.percentages();
        for (int i = 0; i < percentages.length; ++i) {
            outputSlot.appendTooltip((class_2561)class_2561.method_43470((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages[i])));
        }
        SlotWidget secondaryOutputSlot = widgets.addSlot((EmiIngredient)(this.output.size() == 2 ? (EmiIngredient)this.output.get(1) : EmiStack.EMPTY), 91, 4).recipeContext((EmiRecipe)this);
        if (this.output.size() == 2) {
            secondaryOutputSlot.appendTooltip((class_2561)class_2561.method_43471((String)"recipes.energizedpower.transfer.output_percentages"));
            double[] percentages2 = this.secondaryOutputWithPercentages.percentages();
            for (int i = 0; i < percentages2.length; ++i) {
                secondaryOutputSlot.appendTooltip((class_2561)class_2561.method_43470((String)String.format(Locale.ENGLISH, "%2d \u2022 %.2f %%", i + 1, 100.0 * percentages2[i])));
            }
        }
    }
}

